targetlist = {
	["blue"] = {
		["Battle Group CAP"] = {
			task = "CAP",
			priority = 20,
			attributes = {"CV CAP"},
			firepower = {
				min = 2,
				max = 2,
			},
			slaved = {"CVN-71 Theodore Roosevelt", 335, 80000},
			radius = 111000,
			text = "",
		},
		["CAP Sharjah"] = {
			task = "CAP",
			priority = 20,
			attributes = {"Air Forces"},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP Sharjah",
			radius = 50000,
			axis = 100, --in degrees
			text = "east of Sharjah",
			inactive = false,
		},
		["AWACS"] = {
			task = "AWACS",
			priority = 10,
			attributes = {"Sentry"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "AWACS",
			--radius = 15000,
			axis = 100, --in degrees
			text = "",
		},		
		["Battle Group AEW"] = {
			task = "AWACS",
			priority = 10,
			attributes = {"AEW"},
			firepower = {
				min = 1,
				max = 1,
			},
			slaved = {"CVN-71 Theodore Roosevelt",320, 45000},
			text = "",
		},
		["Roosevelt SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 10,
			},
			base = "CVN-71 Theodore Roosevelt",
			radius = 300000,
			inactive = false,
		},
		["Tarawa SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 10,
			},
			base = "LHA_Tarawa",
			radius = 300000,
			inactive = false,
		},
		["Jazirat al Hamra FARP SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Jazirat al Hamra FARP",
			radius = 50000,
			inactive = false,
		},
		["Ras Al Khaimah Intl SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Ras Al Khaimah Intl",
			radius = 50000,
			inactive = false,
		},
		["Sharjah Intl SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Sharjah Intl",
			radius = 50000,
			inactive = false,
		},
		["Mission Support Tanker"] = {
			task = "Refueling",
			priority = 10,
			attributes = {"medium"},
			firepower = {
				min = 1,
				max = 1,
			},
			slaved = {"CVN-71 Theodore Roosevelt", 330, 40000},
			text = "",
		},
		["Recovery Tanker"] = {
			task = "Refueling",
			priority = 5,
			attributes = {"low"},
			firepower = {
				min = 1,
				max = 1,
			},
			slaved = {"CVN-71 Theodore Roosevelt", 310, 30000},
			text = "",
		},		
		["Tanker Track Center"] = {
			task = "Refueling",
			priority = 10,
			attributes = {"KC135MPRS"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "Tanker Center",
			--radius = 15000,
			axis = 100, --in degrees
			text = "",
		},
		["Tanker KC135"] = {
			task = "Refueling",
			priority = 10,
			attributes = {"KC135"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "Tanker KC135",
			--radius = 15000,
			axis = 100, --in degrees
			text = "",
		},
		["Dubai Intl Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "Dubai Intl",
			radius = 150000,
		},
		["Al Dhafra AB Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 2,
				packmax = 3,
			},
			base = "Al Dhafra AFB",
			radius = 150000,
		},
		["AEW"] = {
			task = "AWACS",
			priority = 20,
			attributes = {"AEW"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "AEW",
			--radius = 15000,
			axis = 90, --in degrees
			text = "",
			inactive = true,
		},
		["CV Tanker Track"] = {
			task = "Refueling",
			priority = 20,
			attributes = {"medium"},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "CV Tanker Track",
			--radius = 15000,
			axis = 90, --in degrees
			text = "Near Kutaisi",
			inactive = true,
		},
		["CVN-71 Theodore Roosevelt Interception"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
				packmax = 3,
			},
			base = "CVN-71 Theodore Roosevelt",
			radius = 150000,
		},
		["Airlift shopper LHA_Nassau"] = {
			task = "Transport",
			priority = 1,
			attributes = {},
			firepower = {
				min = 4,
				max = 4,
			},
			base = "LHA_Nassau",
			destination = "Fujairah Intl",
		},	
		["EWR 1"] = {
			task = "Strike",
			priority = 18,
			zone = "A",
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR 1",
		},
		["EWR 2"] = {
			task = "Strike",
			priority = 15,
			zone = "A",
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR 2",
		},
		["EWR 3"] = {
			task = "Strike",
			priority = 14,
			zone = "A",
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR 3",
		},
		["Bandar-E-Jask Silkworm Battery"] = {
			task = "Strike",
			priority = 20,
			zone = "A",
			picture = {"Bandar-E-Jask Silkworm Battery.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Bandar-E-Jask Silkworm Battery",
		},
		["Al Ima Silkworm Battery"] = {
			task = "Strike",
			inactive = true,
			priority = 16,
			additionalGroupName = {"Al Ima Silkworm Battery AA"},
			zone = "A",
			picture = {"Al Ima Silkworm Battery.png", "Al Ima Silkworm Battery-position.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "Al Ima Silkworm Battery",
		},
		["Scud-1"] = {
			task = "Strike",
			priority = 9,
			zone = "A",
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Scud-1",
			inactive = true,
		},
		["Scud-2"] = {
			task = "Strike",
			priority = 9,
			zone = "A",
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Scud-2",
			inactive = true,
		},
		["Scud-3"] = {
			task = "Strike",
			priority = 9,
			zone = "A",
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "Scud-3",
			inactive = true,
		},
		["SA-6 Gainful Site E-1"] = {
			task = "Strike",
			priority = 19,
			picture = {"SA-6 Gainful Site E-1.png"},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "SA-6 Gainful Site E-1",
		},
		["Abu Musa Island Airport"] = {
			inactive = false,
			task = "Strike",
			priority = 4,
			zone = "A",
			picture = {"AbuMusa1.png", "AbuMusa2.png"},
			attributes = {"Structure"},
			db_airbaseName = "Abu Musa Island",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Abu Musa Control Tower",
					x = -31197.27734375,
					y = -122174.9921875,
				},
				[2] = {
					name = "Abu Musa Hangar 1",
					x = -31198.244140625,
					y = -122061.3671875,
				},
				[3] = {
					name = "Abu Musa Hangar 2",
					x = -31333.822265625,
					y = -122244.9296875,
				},
				[4] = {
					name = "Abu Musa HQ",
					x = -31287.83203125,
					y = -122282.46875,
				},
				[5] = {
					name = "Abu Musa Fuel Tank 1",
				},
				[6] = {
					name = "Abu Musa Fuel Tank 2",
				},
				[7] = {
					name = "Abu Musa Fuel Tank 3",
				},
				[8] = {
					name = "Abu Musa Fuel Tank 4",
				},
				[9] = {
					name = "Abu Musa Fuel Tank 5",
				},
				[10] = {
					name = "Abu Musa Ammo Shelter 1",
				},
				[11] = {
					name = "Abu Musa Ammo Shelter 2",
				},
				[12] = {
					name = "Abu Musa Comm Center",
				},
			},
		},
		["Abu Musa Island Airport Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 8,
            picture = {"AbuMusa1.png", "AbuMusa2.png"},
            attributes = {"Runway"},
            db_airbaseName = "Abu Musa Island",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["2nd Iranian Transport fleet"] = {
			task = "Strike",
			priority = 7,
			zone = "A",
			picture = {"Khasab Harbor.png"},
			attributes = {"Structure"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "2nd Iranian Transport fleet 1",
				},
				[2] = {
					name = "2nd Iranian Transport fleet 2",
				},
				[3] = {
					name = "2nd Iranian Transport fleet 3",
				},
				[4] = {
					name = "2nd Iranian Transport fleet 4",
				},
				[5] = {
					name = "2nd Iranian Transport fleet 5",
				},
				[6] = {
					name = "2nd Iranian Transport fleet 6",
				},
			},
		},
		["Iranian West frontline 1st Bat"] = {
			task = "Strike",
			priority = 5,
			additionalGroupName = {"Iranian West frontline 1st Bat-AA", "Iranian West frontline 1st Bat-13"},
			zone = "A",
			picture = {"Iranian West Front Bat.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline 1st Bat-1",
				},
				[2] = {
					name = "Iranian West frontline 1st Bat-3",
				},
				[3] = {
					name = "Iranian West frontline 1st Bat-4",
				},
				[4] = {
					name = "Iranian West frontline 1st Bat-5",
				},
				[5] = {
					name = "Iranian West frontline 1st Bat-6",
				},	
				[6] = {
					name = "Iranian West frontline 1st Bat-9",
				},	
				[7] = {
					name = "Iranian West frontline 1st Bat-11",
				},
			},
		},
		["Iranian West frontline 3rd Bat"] = {
			task = "Strike",
			priority = 5,
			additionalGroupName = {"Iranian West frontline 3rd Bat-AA", "Iranian West frontline 3rd Bat-13"},
			zone = "A",
			picture = {"Iranian West Front Bat.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline 3rd Bat-1",
				},
				[2] = {
					name = "Iranian West frontline 3rd Bat-3",
				},
				[3] = {
					name = "Iranian West frontline 3rd Bat-4",
				},
				[4] = {
					name = "Iranian West frontline 3rd Bat-5",
				},
				[5] = {
					name = "Iranian West frontline 3rd Bat-6",
				},
				[6] = {
					name = "Iranian West frontline 3rd Bat-8",
				},	
				[7] = {
					name = "Iranian West frontline 3rd Bat-10",
				},	
				[8] = {
					name = "Iranian West frontline 3rd Bat-12",
				},
			},
		},
		["Iranian West frontline 4th Bat"] = {
			task = "Strike",
			priority = 5,
			additionalGroupName = {"Iranian West frontline 4th Bat-AA", "Iranian West frontline 4th Bat-13"},
			zone = "A",
			picture = {"Iranian West Front Bat.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline 4th Bat-1",
				},
				[2] = {
					name = "Iranian West frontline 4th Bat-3",
				},
				[3] = {
					name = "Iranian West frontline 4th Bat-6",
				},
				[4] = {
					name = "Iranian West frontline 4th Bat-8",
				},	
				[5] = {
					name = "Iranian West frontline 4th Bat-11",
				},
			},
		},
		["Iranian West frontline 5th Bat"] = {
			task = "Strike",
			priority = 5,
			zone = "A",
			additionalGroupName = {"Iranian West frontline 5th Bat-AA", "Iranian West frontline 5th Bat-13"},
			picture = {"Iranian West Front Bat.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline 5th Bat-1",
				},
				[2] = {
					name = "Iranian West frontline 5th Bat-3",
				},
				[3] = {
					name = "Iranian West frontline 5th Bat-5",
				},
				[4] = {
					name = "Iranian West frontline 5th Bat-7",
				},	
				[5] = {
					name = "Iranian West frontline 5th Bat-10",
				},	
				[6] = {
					name = "Iranian West frontline 5th Bat-11",
				},
			},
		},
		["Iranian West frontline 2nd Bat"] = {
			task = "Strike",
			priority = 5,
			additionalGroupName = {"Iranian West frontline 2nd Bat-AA", "Iranian West frontline 2nd Bat-13"},
			zone = "A",
			picture = {"Iranian West Front Bat.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline 2nd Bat-1",
				},
				[2] = {
					name = "Iranian West frontline 2nd Bat-4",
				},
				[3] = {
					name = "Iranian West frontline 2nd Bat-5",
				},
				[4] = {
					name = "Iranian West frontline 2nd Bat-8",
				},	
				[5] = {
					name = "Iranian West frontline 2nd Bat-9",
				},	
				[6] = {
					name = "Iranian West frontline 2nd Bat-12",
				},
			},
		},
		["Iranian West frontline convoy 1"] = {
			task = "Strike",
			priority = 8,
			additionalGroupName = {"Iranian West frontline convoy 1-AA", "Iranian West frontline convoy 1-13"},
			zone = "A",
			picture = {"Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline convoy 1-1",
				},
				[2] = {
					name = "Iranian West frontline convoy 1-2",
				},
				[3] = {
					name = "Iranian West frontline convoy 1-3",
				},
				[4] = {
					name = "Iranian West frontline convoy 1-4",
				},
				[5] = {
					name = "Iranian West frontline convoy 1-5",
				},
				[6] = {
					name = "Iranian West frontline convoy 1-6",
				},
				[7] = {
					name = "Iranian West frontline convoy 1-7",
				},
				[8] = {
					name = "Iranian West frontline convoy 1-8",
				},
			},
		},
		["Iranian West frontline convoy 2"] = {
			task = "Strike",
			priority = 8,
			additionalGroupName = {"Iranian West frontline convoy 2-AA", "Iranian West frontline convoy 2-13"},
			zone = "A",
			picture = {"Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Iranian West frontline convoy 2-1",
				},
				[2] = {
					name = "Iranian West frontline convoy 2-2",
				},
				[3] = {
					name = "Iranian West frontline convoy 2-3",
				},
				[4] = {
					name = "Iranian West frontline convoy 2-4",
				},
				[5] = {
					name = "Iranian West frontline convoy 2-5",
				},
				[6] = {
					name = "Iranian West frontline convoy 2-6",
				},
				[7] = {
					name = "Iranian West frontline convoy 2-7",
				},
				[8] = {
					name = "Iranian West frontline convoy 2-8",
				},
			},
		},
		["Bukha Iranian Landing Troops"] = {
			task = "Strike",
			priority = 14,
			additionalGroupName = {"Bukha Iranian AA", "Bukha Iranian AA-1"},
			zone = "A",
			picture = {"Oman_Front-1.png", "Bukha Harbor.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Bukha Iranian Landing Troops 1",
				},
				[2] = {
					name = "Bukha Iranian Landing Troops 2",
				},
				[3] = {
					name = "Bukha Iranian Landing Troops 3",
				},
				[4] = {
					name = "Bukha Iranian Landing Troops 4",
				},
				[5] = {
					name = "Bukha Iranian Landing Troops 5",
				},
				[6] = {
					name = "Bukha Iranian Landing Troops 6",
				},
				[7] = {
					name = "Bukha Iranian Landing Troops 7",
				},
				[8] = {
					name = "Bukha Iranian Landing Troops 8",
				},	
				[9] = {
					name = "Bukha Iranian Landing Troops 10",
				},
				[10] = {
					name = "Bukha Iranian Landing Troops 14",
				},
				[11] = {
					name = "Bukha Iranian Landing Troops 15",
				},	
				[12] = {
					name = "Bukha Iranian Landing Troops 16",
				},	
				[13] = {
					name = "Bukha Iranian Landing Troops 21",
				},	
				[14] = {
					name = "Bukha Iranian Landing Troops 22",
				},
				[15] = {
					name = "Bukha Iranian Landing Troops 23",
				},
				[16] = {
					name = "Bukha Iranian Landing Troops 24",
				},	
				[17] = {
					name = "Bukha Iranian Landing Troops 27",
				},	
				[18] = {
					name = "Bukha Iranian Landing Troops 28",
				},
				[19] = {
					name = "Bukha Iranian Landing Troops 29",
				},	
				[20] = {
					name = "Bukha Iranian Landing Troops 30",
				},
			},
		},				
		["Bukha Iranian Command Post"] = {
			task = "Strike",
			priority = 8,
			zone = "A",
			picture = {"Oman_Front-1.png", "Bukha Harbor.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Bukha Iranian Command Post 3",
				},
				[2] = {
					name = "Bukha Iranian Command Post 4",
				},
				[3] = {
					name = "Bukha Iranian Command Post 5",
				},	
				[4] = {
					name = "Bukha Iranian Command Post 6",
				},
				[5] = {
					name = "Bukha Iranian Command Post 9",
				},	
				[6] = {
					name = "Bukha Iranian Command Post 10",
				},
			},
		},
		["Bukha Iranian convoy 1"] = {
			task = "Strike",
			priority = 11,
			additionalGroupName = {"Bukha Iranian convoy AA"},
			zone = "A",
			picture = {"Oman_Front-1.png", "Bukha Harbor.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Bukha Iranian convoy 1-1",
				},
				[2] = {
					name = "Bukha Iranian convoy 1-2",
				},
				[3] = {
					name = "Bukha Iranian convoy 1-3",
				},
				[4] = {
					name = "Bukha Iranian convoy 1-4",
				},
				[5] = {
					name = "Bukha Iranian convoy 1-5",
				},
				[6] = {
					name = "Bukha Iranian convoy 1-6",
				},
				[7] = {
					name = "Bukha Iranian convoy 1-7",
				},
				[8] = {
					name = "Bukha Iranian convoy 1-8",
				},	
				[9] = {
					name = "Bukha Iranian convoy 1-9",
				},	
				[10] = {
					name = "Bukha Iranian convoy 1-10",
				},	
				[11] = {
					name = "Bukha Iranian convoy 1-11",
				},	
				[12] = {
					name = "Bukha Iranian convoy 1-12",
				},
				[13] = {
					name = "Bukha Iranian convoy 1-13",
				},
				[14] = {
					name = "Bukha Iranian convoy 1-14",
				},
				[15] = {
					name = "Bukha Iranian convoy 1-15",
				},	
				[16] = {
					name = "Bukha Iranian convoy 1-16",
				},	
				[17] = {
					name = "Bukha Iranian convoy 1-17",
				},	
				[18] = {
					name = "Bukha Iranian convoy 1-18",
				},	
				[19] = {
					name = "Bukha Iranian convoy 1-19",
				},	
			},
		},	
		["Khasab debarqued troops"] = {
			task = "Strike",
			priority = 11,
			additionalGroupName = {"Khasab Harbor defense"},
			zone = "A",
			picture = {"Khasab Harbor.png", "Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Khasab debarqued troops 1",
				},
				[2] = {
					name = "Khasab debarqued troops 2",
				},
				[3] = {
					name = "Khasab debarqued troops 3",
				},
				[4] = {
					name = "Khasab debarqued troops 4",
				},
				[5] = {
					name = "Khasab debarqued troops 5",
				},
				[6] = {
					name = "Khasab debarqued troops 11",
				},	
				[7] = {
					name = "Khasab debarqued troops 12",
				},
				[8] = {
					name = "Khasab debarqued troops 13",
				},
				[9] = {
					name = "Khasab debarqued troops 14",
				},
				[10] = {
					name = "Khasab debarqued troops 15",
				},	
				[11] = {
					name = "Khasab debarqued troops 21",
				},	
				[12] = {
					name = "Khasab debarqued troops 22",
				},
				[13] = {
					name = "Khasab debarqued troops 23",
				},
				[14] = {
					name = "Khasab debarqued troops 24",
				},
				[15] = {
					name = "Khasab debarqued troops 25",
				},	
				[16] = {
					name = "Khasab debarqued troops 31",
				},	
				[17] = {
					name = "Khasab debarqued troops 32",
				},
				[18] = {
					name = "Khasab debarqued troops 33",
				},
				[19] = {
					name = "Khasab debarqued troops 34",
				},
				[20] = {
					name = "Khasab debarqued troops 35",
				},
			},
		},
		["Khasab debarqued Hawk batterie"] = {
			task = "Strike",
			inactive = false,
			priority = 15,
			additionalGroupName = {"Khasab debarqued Hawk batterie AA"},
			zone = "A",
			picture = {"Khasab Harbor.png", "Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Khasab debarqued Hawk batterie 1",
				},
				[2] = {
					name = "Khasab debarqued Hawk batterie 2",
				},
				[3] = {
					name = "Khasab debarqued Hawk batterie 3",
				},
				[4] = {
					name = "Khasab debarqued Hawk batterie 4",
				},	
				[5] = {
					name = "Khasab debarqued Hawk batterie 5",
				},	
				[6] = {
					name = "Khasab debarqued Hawk batterie 6",
				},
				[7] = {
					name = "Khasab debarqued Hawk batterie 7",
				},
				[8] = {
					name = "Khasab debarqued Hawk batterie 8",
				},
				[9] = {
					name = "Khasab debarqued Hawk batterie 9",
				},
				[10] = {
					name = "Khasab debarqued Hawk batterie 10",
				},
				[11] = {
					name = "Khasab debarqued Hawk batterie 11",
				},	
				[12] = {
					name = "Khasab debarqued Hawk batterie 12",
				},
				[13] = {
					name = "Khasab debarqued Hawk batterie 13",
				},	
				[14] = {
					name = "Khasab debarqued Hawk batterie 14",
				},
				[15] = {
					name = "Khasab debarqued Hawk batterie 15",
				},
				[16] = {
					name = "Khasab debarqued Hawk batterie 16",
				},
				[17] = {
					name = "Khasab debarqued Hawk batterie 17",
				},
				[18] = {
					name = "Khasab debarqued Hawk batterie 18",
				},
				[19] = {
					name = "Khasab debarqued Hawk batterie 19",
				},
				[20] = {
					name = "Khasab debarqued Hawk batterie 20",
				},
				[21] = {
					name = "Khasab debarqued Hawk batterie 21",
				},
				[22] = {
					name = "Khasab debarqued Hawk batterie 22",
				},
			},
		},
		["Khasab debarqued Silkworms batteries"] = {
			task = "Strike",
			priority = 12,
			zone = "A",
			picture = {"Khasab Harbor.png", "Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Khasab debarqued Silkworms batteries 1",
				},
				[2] = {
					name = "Khasab debarqued Silkworms batteries 2",
				},
				[3] = {
					name = "Khasab debarqued Silkworms batteries 3",
				},
				[4] = {
					name = "Khasab debarqued Silkworms batteries 4",
				},
				[5] = {
					name = "Khasab debarqued Silkworms batteries 5",
				},
				[6] = {
					name = "Khasab debarqued Silkworms batteries 6",
				},
				[7] = {
					name = "Khasab debarqued Silkworms batteries 7",
				},
				[8] = {
					name = "Khasab debarqued Silkworms batteries 8",
				},	
				[9] = {
					name = "Khasab debarqued Silkworms batteries 9",
				},	
				[10] = {
					name = "Khasab debarqued Silkworms batteries 10",
				},	
				[11] = {
					name = "Khasab debarqued Silkworms batteries 11",
				},	
				[12] = {
					name = "Khasab debarqued Silkworms batteries 12",
				},
			},
		},
		["Mountain Iranian convoy 1"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"Mountain Iranian convoy 1-AA"},
			zone = "A",
			picture = {"Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mountain Iranian convoy 1-1",
				},
				[2] = {
					name = "Mountain Iranian convoy 1-2",
				},
				[3] = {
					name = "Mountain Iranian convoy 1-3",
				},
				[4] = {
					name = "Mountain Iranian convoy 1-4",
				},
				[5] = {
					name = "Mountain Iranian convoy 1-5",
				},
				[6] = {
					name = "Mountain Iranian convoy 1-6",
				},
				[7] = {
					name = "Mountain Iranian convoy 1-7",
				},
				[8] = {
					name = "Mountain Iranian convoy 1-8",
				},	
				[9] = {
					name = "Mountain Iranian convoy 1-9",
				},	
				[10] = {
					name = "Mountain Iranian convoy 1-10",
				},	
				[11] = {
					name = "Mountain Iranian convoy 1-11",
				},	
				[12] = {
					name = "Mountain Iranian convoy 1-12",
				},
				[13] = {
					name = "Mountain Iranian convoy 1-13",
				},
				[14] = {
					name = "Mountain Iranian convoy 1-14",
				},
				[15] = {
					name = "Mountain Iranian convoy 1-15",
				},	
			},
		},
		["Mountain Iranian convoy 2"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"Mountain Iranian convoy 2-AA"},
			zone = "A",
			picture = {"Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mountain Iranian convoy 2-1",
				},
				[2] = {
					name = "Mountain Iranian convoy 2-2",
				},
				[3] = {
					name = "Mountain Iranian convoy 2-3",
				},
				[4] = {
					name = "Mountain Iranian convoy 2-4",
				},
				[5] = {
					name = "Mountain Iranian convoy 2-5",
				},
				[6] = {
					name = "Mountain Iranian convoy 2-6",
				},
				[7] = {
					name = "Mountain Iranian convoy 2-7",
				},
				[8] = {
					name = "Mountain Iranian convoy 2-8",
				},	
				[9] = {
					name = "Mountain Iranian convoy 2-9",
				},	
				[10] = {
					name = "Mountain Iranian convoy 2-10",
				},	
				[11] = {
					name = "Mountain Iranian convoy 2-11",
				},	
				[12] = {
					name = "Mountain Iranian convoy 2-12",
				},
				[13] = {
					name = "Mountain Iranian convoy 2-13",
				},
				[14] = {
					name = "Mountain Iranian convoy 2-14",
				},
				[15] = {
					name = "Mountain Iranian convoy 2-15",
				},	
			},
		},
		["Mountain Iranian convoy 3"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"Mountain Iranian convoy 3-31"},
			zone = "A",
			picture = {"Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mountain Iranian convoy 3-1",
				},
				[2] = {
					name = "Mountain Iranian convoy 3-2",
				},
				[3] = {
					name = "Mountain Iranian convoy 3-3",
				},
				[4] = {
					name = "Mountain Iranian convoy 3-4",
				},
				[5] = {
					name = "Mountain Iranian convoy 3-5",
				},
				[6] = {
					name = "Mountain Iranian convoy 3-6",
				},
				[7] = {
					name = "Mountain Iranian convoy 3-7",
				},
				[8] = {
					name = "Mountain Iranian convoy 3-8",
				},	
				[9] = {
					name = "Mountain Iranian convoy 3-9",
				},	
				[10] = {
					name = "Mountain Iranian convoy 3-10",
				},	
				[11] = {
					name = "Mountain Iranian convoy 3-11",
				},	
				[12] = {
					name = "Mountain Iranian convoy 3-12",
				},
				[13] = {
					name = "Mountain Iranian convoy 3-13",
				},
				[14] = {
					name = "Mountain Iranian convoy 3-14",
				},
				[15] = {
					name = "Mountain Iranian convoy 3-15",
				},	
			},
		},
		["Mountain Iranian convoy 4"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"Mountain Iranian convoy 4-AA", "Mountain Iranian convoy 4-31"},
			zone = "A",
			picture = {"Oman_Front-1.png"},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mountain Iranian convoy 4-1",
				},
				[2] = {
					name = "Mountain Iranian convoy 4-2",
				},
				[3] = {
					name = "Mountain Iranian convoy 4-3",
				},
				[4] = {
					name = "Mountain Iranian convoy 4-4",
				},
				[5] = {
					name = "Mountain Iranian convoy 4-5",
				},
				[6] = {
					name = "Mountain Iranian convoy 4-6",
				},
				[7] = {
					name = "Mountain Iranian convoy 4-7",
				},
				[8] = {
					name = "Mountain Iranian convoy 4-8",
				},	
				[9] = {
					name = "Mountain Iranian convoy 4-9",
				},	
				[10] = {
					name = "Mountain Iranian convoy 4-10",
				},	
				[11] = {
					name = "Mountain Iranian convoy 4-11",
				},	
				[12] = {
					name = "Mountain Iranian convoy 4-12",
				},
				[13] = {
					name = "Mountain Iranian convoy 4-13",
				},
				[14] = {
					name = "Mountain Iranian convoy 4-14",
				},
				[15] = {
					name = "Mountain Iranian convoy 4-15",
				},	
			},
		},
		["Mina Saqr debarqued troops"] = {
			task = "Strike",
			priority = 13,
			zone = "A",
			picture = {"Oman_Front-1.png", "Mina Saqr Harbor.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mina Saqr debarqued troops-1",
				},
				[2] = {
					name = "Mina Saqr debarqued troops-2",
				},
				[3] = {
					name = "Mina Saqr debarqued troops-3",
				},
				[4] = {
					name = "Mina Saqr debarqued troops-4",
				},
				[5] = {
					name = "Mina Saqr debarqued troops-5",
				},
				[6] = {
					name = "Mina Saqr debarqued troops-6",
				},
				[7] = {
					name = "Mina Saqr debarqued troops-13",
				},
				[8] = {
					name = "Mina Saqr debarqued troops-15",
				},	
				[9] = {
					name = "Mina Saqr debarqued troops-17",
				},	
				[10] = {
					name = "Mina Saqr debarqued troops-19",
				},
				[11] = {
					name = "Mina Saqr debarqued troops-21",
				},
				[12] = {
					name = "Mina Saqr debarqued troops-23",
				},
				[13] = {
					name = "Mina Saqr debarqued troops-25",
				},	
				[14] = {
					name = "Mina Saqr debarqued troops-27",
				},	
				[15] = {
					name = "Mina Saqr debarqued troops-28",
				},
				[16] = {
					name = "Mina Saqr debarqued troops-29",
				},	
				[17] = {
					name = "Mina Saqr debarqued troops-30",
				},	
				[18] = {
					name = "Mina Saqr debarqued troops-31",
				},	
				[19] = {
					name = "Mina Saqr debarqued troops-32",
				},
				[20] = {
					name = "Mina Saqr debarqued troops-33",
				},	
				[21] = {
					name = "Mina Saqr debarqued troops-38",
				},
				[22] = {
					name = "Mina Saqr debarqued troops-39",
				},	
				[23] = {
					name = "Mina Saqr debarqued troops-40",
				},
			},
		},
		["Mina Saqr convoy 1"] = {
			task = "Strike",
			priority = 7,
			additionalGroupName = {"Mina Saqr convoy 1 AA"},
			zone = "A",
			picture = {"Oman_Front-1.png", "Mina Saqr Harbor.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mina Saqr convoy 1-1",
				},
				[2] = {
					name = "Mina Saqr convoy 1-2",
				},
				[3] = {
					name = "Mina Saqr convoy 1-3",
				},
				[4] = {
					name = "Mina Saqr convoy 1-4",
				},
				[5] = {
					name = "Mina Saqr convoy 1-5",
				},
				[6] = {
					name = "Mina Saqr convoy 1-6",
				},
				[7] = {
					name = "Mina Saqr convoy 1-7",
				},
				[8] = {
					name = "Mina Saqr convoy 1-8",
				},	
				[9] = {
					name = "Mina Saqr convoy 1-9",
				},	
				[10] = {
					name = "Mina Saqr convoy 1-10",
				},	
				[11] = {
					name = "Mina Saqr convoy 1-11",
				},	
				[12] = {
					name = "Mina Saqr convoy 1-12",
				},
				[13] = {
					name = "Mina Saqr convoy 1-13",
				},
				[14] = {
					name = "Mina Saqr convoy 1-14",
				},
				[15] = {
					name = "Mina Saqr convoy 1-15",
				},	
				[16] = {
					name = "Mina Saqr convoy 1-16",
				},	
				[17] = {
					name = "Mina Saqr convoy 1-17",
				},	
				[18] = {
					name = "Mina Saqr convoy 1-18",
				},	
				[19] = {
					name = "Mina Saqr convoy 1-19",
				},	
				[20] = {
					name = "Mina Saqr convoy 1-20",
				},
			},
		},
		["Mina Saqr debarqued SAM systems"] = {
			task = "Strike",
			inactive = true,
			additionalGroupName = {"Mina Saqr debarqued SAM systems AA"},
			priority = 14,
			zone = "A",
			picture = {"Oman_Front-1.png", "Mina Saqr Harbor.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Mina Saqr debarqued SAM systems-1",
				},
				[2] = {
					name = "Mina Saqr debarqued SAM systems-2",
				},
				[3] = {
					name = "Mina Saqr debarqued SAM systems-3",
				},
				[4] = {
					name = "Mina Saqr debarqued SAM systems-4",
				},
				[5] = {
					name = "Mina Saqr debarqued SAM systems-5",
				},
				[6] = {
					name = "Mina Saqr debarqued SAM systems-6",
				},
				[7] = {
					name = "Mina Saqr debarqued SAM systems-7",
				},
			},
		},
		["Mina Saqr Hawk Battery"] = {
			inactive = true,
			task = "Strike",
			priority = 16,
			additionalGroupName = {"Mina Saqr Hawk Battery AA"},
			picture = {""},
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Mina Saqr Hawk Battery",
		},
		["Frontline SA-6"] = {
			inactive = true,
			task = "Strike",
			priority = 16,
			additionalGroupName = {"Frontline SA-6 AA"},
			picture = {"Frontline SA-6.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "Frontline SA-6",
		},
		["Khasab-SA-2"] = {
			inactive = true,
			task = "Strike",
			priority = 16,
			additionalGroupName = {"Khasab-SA-2 AA"},
			picture = {"Khasab-SA-2 position.png", "Khasab-SA-2.png"},
			attributes = {"SAM"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "vehicle",
			name = "Khasab-SA-2",
		},
		["1st Iranian Transport fleet"] = {
			task = "Anti-ship Strike",
			priority = 7,
			zone = "A",
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "ship",
			name = "1st Iranian Transport fleet",
		},
		["3rd Iranian Transport fleet"] = {
			task = "Anti-ship Strike",
			priority = 7,
			zone = "A",
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "ship",
			name = "3rd Iranian Transport fleet",
		},
		["4th Iranian Transport fleet"] = {
			task = "Anti-ship Strike",
			priority = 7,
			zone = "A",
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "ship",
			name = "4th Iranian Transport fleet",
		},
		["5th Iranian Transport fleet"] = {
			task = "Anti-ship Strike",
			priority = 7,
			zone = "A",
			picture = {"Oman_Front-1.png", "Mina Saqr Harbor.png"},
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "ship",
			name = "5th Iranian Transport fleet",
		},
		["Al Mina Ships"] = {
			task = "Anti-ship Strike",
			priority = 8,
			zone = "A",
			picture = {"Oman_Front-1.png", "Al Mina Ships.png"},
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "ship",
			name = "Al Mina Ships",
		},
		["Iranian suicide speedboat fleet-1"] = {
			task = "Anti-ship Strike",
			priority = 20,
			attributes = {"ship"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "ship",
			name = "Iranian suicide speedboat fleet-1",
		},
		["Khasab Airbase"] = {
			inactive = false,
			task = "Strike",
			priority = 14,
			zone = "A",
			picture = {"Oman_Front-1.png", "Khasab Airbase.png"},
			attributes = {"Structure"},
			db_airbaseName = "Khasab",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Khasab Airbase Intel Center",
					x = -128.62350463867,
					y = -513.59222412109,
				},				
				[2] = {
					name = "Khasab Airbase Main Hangar",
					x = -628.54180908203,
					y = -595.2451171875,
				},
				[3] = {
					name = "Khasab Airbase Hangar 2",
					x = -756.59362792969,
					y = -612.51226806641,
				},				
				[4] = {
					name = "Khasab Airbase Hangar 3",
					x = -796.85180664063,
					y = -629.59075927734,
				},
				[5] = {
					name = "Khasab Airbase Hangar 4",
					x = -531.39874267578,
					y = -574.55676269531,
				},
				[6] = {
					name = "Khasab Airbase Command HQ",
					x = -388.31140136719,
					y = -617.20568847656,
				},
				[7] = {
					name = "Khasab Airbase Com Center 1",
					x = -587.76000976563,
					y = -678.24359130859,
				},
				[8] = {
					name = "Khasab Airbase Com Center 2",
					x = -619.853515625,
					y = -686.11639404297,
				},
				[9] = {
					name = "Khasab Airbase Tech Hangar",
					x = -694.47631835938,
					y = -588.74243164063,
				},
				[10] = {
					name = "Khasab Airbase Light Hangar 1",
					x = -492.86471557617,
					y = -561.50054931641,
				},
				[11] = {
					name = "Khasab Airbase Fuel Tank 1",
				},
				[12] = {
					name = "Khasab Airbase Fuel Tank 2",
				},
				[13] = {
					name = "Khasab Airbase Fuel Tank 3",
				},
				[14] = {
					name = "Khasab Airbase Fuel Tank 4",
				},
				[15] = {
					name = "Khasab Airbase Fuel Tank 5",
				},
				[16] = {
					name = "Khasab Airbase Fuel Tank 6",
				},
				[17] = {
					name = "Khasab Airbase Ammo Storage 1",
				},
				[18] = {
					name = "Khasab Airbase Ammo Storage 2",
				},
				[19] = {
					name = "Khasab Airbase Ammo Storage 3",
				},
				[20] = {
					name = "Khasab Airbase Ammo Storage 4",
				},
				[21] = {
					name = "Khasab Airbase Main Comm Center",
				},
			},
		},
		["Khasab Airbase Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 8,
			zone = "A",
            picture = {"Oman_Front-1.png", "Khasab Airbase.png"},
            attributes = {"Runway"},
            db_airbaseName = "Khasab",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Bandar-e-Jask airfield"] = {
			inactive = false,
			task = "Strike",
			priority = 20,
			zone = "A",
			picture = {"Bandar e Jask airfield.png"},
			attributes = {"Structure"},
			db_airbaseName = "Bandar-e-Jask",
			firepower = {
				min = 4,
				max = 8,
			},
			elements = {
				[1] = {
					name = "Bandar e Jask airfield Hangar 1",
					x = -57542.36328125,
					y = 154717.6875,
				},
				[2] = {
					name = "Bandar e Jask airfield Hangar 2",
					x = -57542.36328125,
					y = 154717.6875,
				},
				[3] = {
					name = "Bandar e Jask airfield Hangar 3",
					x = -57498.95703125,
					y = 154836.25,
				},
				[4] = {
					name = "Bandar e Jask airfield Hangar 4",
					x = -57528.09765625,
					y = 154872.734375,
				},
				[5] = {
					name = "Bandar e Jask airfield Hangar 5",
					x = -57557.83203125,
					y = 154846.4375,
				},
				[6] = {
					name = "Bandar e Jask airfield Fuel Tank-1",
				},
				[7] = {
					name = "Bandar e Jask airfield Fuel Tank-2",
				},
				[8] = {
					name = "Bandar e Jask airfield Ammo Storage-1",
				},
				[9] = {
					name = "Bandar e Jask airfield Ammo Storage-2",
				},
				[10] = {
					name = "Bandar e Jask airfield Comm Center",
				},
			},
		},
		["Bandar-e-Jask airfield Runway"] = {
            inactive = false,
			task = "Runway Attack",
            priority = 8,
			zone = "A",
            picture = {"Bandar e Jask airfield.png"},
            attributes = {"Runway"},
            db_airbaseName = "Bandar-e-Jask",
            firepower = {
                min = 4,
                max = 8,
            },
        },
		["Abu Musa Ships Facilities - N255237 E0550065"] = {
			task = "Strike",
			priority = 8,
			zone = "A",
			picture = {"AbuMusa1.png", "AbuMusaShipsFacilities.png"},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "Tanker 1",
				},
				[2] = {
					name = "Cargo ship 1",
				},
				[3] = {
					name = "Cargo ship 2",
				},
				[4] = {
					name = "SS-N-2-1",
				},
				[5] = {
					name = "SS-N-2-2",
				},
				[6] = {
					name = "SS-N-2-3",
				},
				[7] = {
					name = "SS-N-2-4",
				},
				[8] = {
					name = "CP truck 1",
				},
				[9] = {
					name = "Buk CC 1",
				},
				[10] = {
					name = "Buk LN 1",
				},
				[11] = {
					name = "Buk LN 2",
				},
				[12] = {
					name = "Buk LN 3",
				},
				[13] = {
					name = "Buk SR 1",
				},
				[14] = {
					name = "Truck 1",
				},
				[15] = {
					name = "Truck 2",
				},
				[16] = {
					name = "Truck 3",
				},
				[17] = {
					name = "Truck 4",
				},
				[18] = {
					name = "Truck 5",
				},
				[19] = {
					name = "Truck 6",
				},
				[20] = {
					name = "Truck 7",
				},
				[21] = {
					name = "Truck 8",
				},
				[22] = {
					name = "Truck 9",
				},
				[23] = {
					name = "Truck 10",
				},
				[24] = {
					name = "Fuel truck 1",
				},
				[25] = {
					name = "Fuel truck 2",
				},
				[26] = {
					name = "Fuel truck 3",
				},
				[27] = {
					name = "Fuel truck 4",
				},
				[28] = {
					name = "Fuel truck 5",
				},
				[29] = {
					name = "Fuel truck 6",
				},
				[30] = {
					name = "SS-N-2-1 Truck",
				},
				[31] = {
					name = "SS-N-2-2 Truck",
				},
				[32] = {
					name = "SS-N-2-3 Truck",
				},
				[33] = {
					name = "SS-N-2-4 Truck",
				},				
			},
		}, 		
	},
	["red"] = {
		["Al Ima FARP SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Al Ima FARP",
			radius = 50000,
			inactive = false,
		},
		["Khasab SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Khasab",
			radius = 50000,
			inactive = false,
		},
		["Bandar Abbas Intl SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Bandar Abbas Intl",
			radius = 50000,
			inactive = false,
		},
		["Al Ima FARP SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Al Ima FARP",
			radius = 50000,
			inactive = false,
		},
		["Bandar-e-Jask SAR Alert"] = {
			task = "SAR",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Bandar-e-Jask",
			radius = 50000,
			inactive = false,
		},
		["Lar Airbase Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 4,
				packmax = 3,
			},
			base = "Lar",
			radius = 200000,
			inactive = false,
		},
		["Shiraz Intl Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 4,
				packmax = 3,
			},
			base = "Shiraz Intl",
			radius = 200000,
			inactive = false,
		},
		["Sirri Island Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
				packmax = 3,
			},
			base = "Sirri Island",
			radius = 50000,
			inactive = false,
		},
		["Tanker Track North"] = {
			task = "Refueling",
			priority = 1,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			refpoint = "Tanker Track North",
			--radius = 20000,
			axis = 90, --in degrees
			text = "North West of Lar Airbase",
		},		
		["Bandar-e-Jask airfield Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 2,
				packmax = 3,
			},
			base = "Bandar-e-Jask",
			radius = 100000,
			inactive = false,
		},
		-- ["Bandar-e-Jask airfield Alert 50"] = {
			-- task = "Intercept",
			-- priority = 10,
			-- attributes = {},
			-- firepower = {
				-- min = 1,
				-- max = 2,
			-- },
			-- base = "Bandar-e-Jask",
			-- radius = 50000,
			-- inactive = false,
		-- },
		["Qeshm Island Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 4,
				packmax = 3,
			},
			base = "Qeshm Island",
			radius = 100000,
			inactive = false,
		},		
		["Khasab Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 4,
				packmax = 3,
			},
			base = "Khasab",
			radius = 50000,
			inactive = false,
		},
		["Bandar Abbas Intl 100 Km Alert"] = {
			task = "Intercept",
			priority = 10,
			attributes = {},
			firepower = {
				min = 1,
				max = 4,
				packmax = 3,
			},
			base = "Bandar Abbas Intl",
			radius = 100000,
			inactive = false,
		},
		["CAP Islands"] = {
			task = "CAP",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP Islands",
			radius = 50000,
			axis = 60, --in degrees
			text = "Center Islands",
			inactive = false,
		},		
		["CAP Khasab"] = {
			task = "CAP",
			priority = 10,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP Khasab",
			radius = 50000,
			axis = 100, --in degrees
			text = "Khasab",
			inactive = false,
		},
		["CAP East"] = {
			task = "CAP",
			priority = 15,
			attributes = {},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP East",
			radius = 50000,
			axis = 100, --in degrees
			text = "South East of Khasab",
			inactive = false,
		},
		["CAP Bandar Abbas"] = {
			task = "CAP",
			priority = 10,
			attributes = {"IRIAF"},
			firepower = {
				min = 2,
				max = 4,
			},
			refpoint = "CAP Bandar Abbas",
			radius = 50000,
			axis = 90, --in degrees
			text = "North of Bandar Abbas",
			inactive = false,
		},		
		["Patriot Battery 1"] = {
			task = "Strike",
			priority = 15,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "Patriot Battery 1",
		},
		["FR Hawk Site 1"] = {
			task = "Strike",
			priority = 5,
			attributes = {"SAM"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "vehicle",
			name = "FR Hawk Site 1",
		},
		["US Army ELINT Station"] = {
			task = "Strike",
			priority = 15,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "US ELINT Antenna Truck 1",
				},
				[2] = {
					name = "US ELINT Antenna Truck 2",
				},
				[3] = {
					name = "US ELINT Crew Van",
				},
				[4] = {
					name = "US ELINT Equipment Van",
				},
				[5] = {
					name = "US ELINT Generator Truck",
				},
			},
		},
		["US Army ELINT Station 2"] = {
			task = "Strike",
			priority = 15,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "US ELINT 2 Antenna Truck 1",
				},
				[2] = {
					name = "US ELINT 2 Antenna Truck 2",
				},
				[3] = {
					name = "US ELINT 2 Crew Van",
				},
				[4] = {
					name = "US ELINT 2 Equipment Van",
				},
				[5] = {
					name = "US ELINT 2 Generator Truck",
				},
			},
		},
		["EAU West Front 1st Bat"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"EAU West Front 1st Bat-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front 1st Bat-2",
				},
				[2] = {
					name = "EAU West Front 1st Bat-3",
				},
				[3] = {
					name = "EAU West Front 1st Bat-6",
				},
				[4] = {
					name = "EAU West Front 1st Bat-8",
				},	
				[5] = {
					name = "EAU West Front 1st Bat-11",
				},
			},
		},
		["EAU West Front 2nd Bat"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"EAU West Front 2nd Bat-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front 2nd Bat-1",
				},
				[2] = {
					name = "EAU West Front 2nd Bat-3",
				},
				[3] = {
					name = "EAU West Front 2nd Bat-5",
				},
				[4] = {
					name = "EAU West Front 2nd Bat-7",
				},	
				[5] = {
					name = "EAU West Front 2nd Bat-10",
				},	
				[6] = {
					name = "EAU West Front 2nd Bat-12",
				},
			},
		},
		["EAU West Front 3rd Bat"] = {
			task = "Strike",
			priority = 10,
			additionalGroupName = {"EAU West Front 3rd Bat-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front 3rd Bat-1",
				},
				[2] = {
					name = "EAU West Front 3rd Bat-3",
				},
				[3] = {
					name = "EAU West Front 3rd Bat-4",
				},
				[4] = {
					name = "EAU West Front 3rd Bat-5",
				},
				[5] = {
					name = "EAU West Front 3rd Bat-7",
				},	
				[6] = {
					name = "EAU West Front 3rd Bat-9",
				},	
				[7] = {
					name = "EAU West Front 3rd Bat-11",
				},	
				[8] = {
					name = "EAU West Front 3rd Bat-12",
				},
			},
		},	
		["EAU West Front HQ"] = {
			task = "Strike",
			priority = 13,
			additionalGroupName = {"EAU West Front HQ-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front HQ-1",
				},
				[2] = {
					name = "EAU West Front HQ-2",
				},
				[3] = {
					name = "EAU West Front HQ-3",
				},
				[4] = {
					name = "EAU West Front HQ-5",
				},
				[5] = {
					name = "EAU West Front HQ-6",
				},
				[6] = {
					name = "EAU West Front HQ-7",
				},
				[7] = {
					name = "EAU West Front HQ-8",
				},	
				[8] = {
					name = "EAU West Front HQ-10",
				},
			},
		},
		["EAU West Front Convoy 1"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU West Front Convoy 1-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front Convoy 1-1",
				},
				[2] = {
					name = "EAU West Front Convoy 1-2",
				},
				[3] = {
					name = "EAU West Front Convoy 1-3",
				},
				[4] = {
					name = "EAU West Front Convoy 1-4",
				},
				[5] = {
					name = "EAU West Front Convoy 1-5",
				},
				[6] = {
					name = "EAU West Front Convoy 1-6",
				},
				[7] = {
					name = "EAU West Front Convoy 1-7",
				},
				[8] = {
					name = "EAU West Front Convoy 1-8",
				},
			},
		},
		["EAU West Front Convoy 2"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU West Front Convoy 2-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front Convoy 2-1",
				},
				[2] = {
					name = "EAU West Front Convoy 2-2",
				},
				[3] = {
					name = "EAU West Front Convoy 2-3",
				},
				[4] = {
					name = "EAU West Front Convoy 2-4",
				},
				[5] = {
					name = "EAU West Front Convoy 2-5",
				},
				[6] = {
					name = "EAU West Front Convoy 2-6",
				},
				[7] = {
					name = "EAU West Front Convoy 2-7",
				},
				[8] = {
					name = "EAU West Front Convoy 2-8",
				},
			},
		},
		["EAU West Front Convoy 3"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU West Front Convoy 3-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 8,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU West Front Convoy 3-1",
				},
				[2] = {
					name = "EAU West Front Convoy 3-2",
				},
				[3] = {
					name = "EAU West Front Convoy 3-3",
				},
				[4] = {
					name = "EAU West Front Convoy 3-4",
				},
				[5] = {
					name = "EAU West Front Convoy 3-5",
				},
				[6] = {
					name = "EAU West Front Convoy 3-6",
				},
				[7] = {
					name = "EAU West Front Convoy 3-7",
				},
				[8] = {
					name = "EAU West Front Convoy 3-8",
				},
			},
		},
		["EAU East Front 4th Bat"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU East Front 4th Bat-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU East Front 4th Bat-2",
				},
				[2] = {
					name = "EAU East Front 4th Bat-4",
				},
				[3] = {
					name = "EAU East Front 4th Bat-5",
				},
				[4] = {
					name = "EAU East Front 4th Bat-6",
				},	
				[5] = {
					name = "EAU East Front 4th Bat-9",
				},	
				[6] = {
					name = "EAU East Front 4th Bat-10",
				},	
				[7] = {
					name = "EAU East Front 4th Bat-12",
				},
			},
		},
		["EAU East Front 5th Bat"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU East Front 4th Bat-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU East Front 5th Bat-1",
				},
				[2] = {
					name = "EAU East Front 5th Bat-2",
				},
				[3] = {
					name = "EAU East Front 5th Bat-3",
				},
				[4] = {
					name = "EAU East Front 5th Bat-4",
				},
				[5] = {
					name = "EAU East Front 5th Bat-6",
				},
				[6] = {
					name = "EAU East Front 5th Bat-7",
				},	
				[7] = {
					name = "EAU East Front 5th Bat-9",
				},	
				[8] = {
					name = "EAU East Front 5th Bat-10",
				},	
				[9] = {
					name = "EAU East Front 5th Bat-12",
				},
			},
		},
		["EAU East Front HQ"] = {
			task = "Strike",
			priority = 13,
			additionalGroupName = {"EAU East Front HQ-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU East Front HQ-1",
				},
				[2] = {
					name = "EAU East Front HQ-2",
				},
				[3] = {
					name = "EAU East Front HQ-3",
				},
				[4] = {
					name = "EAU East Front HQ-4",
				},
				[5] = {
					name = "EAU East Front HQ-5",
				},
				[6] = {
					name = "EAU East Front HQ-6",
				},
				[7] = {
					name = "EAU East Front HQ-7",
				},
				[8] = {
					name = "EAU East Front HQ-8",
				},	
				[9] = {
					name = "EAU East Front HQ-12",
				},
			},
		},
		["EAU East Front Convoy 1"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU East Front Convoy 1 AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU East Front Convoy 1-1",
				},
				[2] = {
					name = "EAU East Front Convoy 1-2",
				},
				[3] = {
					name = "EAU East Front Convoy 1-3",
				},
				[4] = {
					name = "EAU East Front Convoy 1-4",
				},
				[5] = {
					name = "EAU East Front Convoy 1-5",
				},
				[6] = {
					name = "EAU East Front Convoy 1-6",
				},
				[7] = {
					name = "EAU East Front Convoy 1-7",
				},
				[8] = {
					name = "EAU East Front Convoy 1-8",
				},
			},
		},
		["EAU East Front Convoy 2"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU East Front Convoy 2-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU East Front Convoy 2-1",
				},
				[2] = {
					name = "EAU East Front Convoy 2-2",
				},
				[3] = {
					name = "EAU East Front Convoy 2-3",
				},
				[4] = {
					name = "EAU East Front Convoy 2-4",
				},
				[5] = {
					name = "EAU East Front Convoy 2-5",
				},
				[6] = {
					name = "EAU East Front Convoy 2-6",
				},
				[7] = {
					name = "EAU East Front Convoy 2-7",
				},
				[8] = {
					name = "EAU East Front Convoy 2-8",
				},
			},
		},
		["EAU East Front Convoy 3"] = {
			task = "Strike",
			priority = 12,
			additionalGroupName = {"EAU East Front Convoy 3-AA"},
			--picture = {""},
			attributes = {"soft"},
			firepower = {
				min = 4,
				max = 4,
			},
			class = "static",
			elements = {
				[1] = {
					name = "EAU East Front Convoy 3-1",
				},
				[2] = {
					name = "EAU East Front Convoy 3-2",
				},
				[3] = {
					name = "EAU East Front Convoy 3-3",
				},
				[4] = {
					name = "EAU East Front Convoy 3-4",
				},
				[5] = {
					name = "EAU East Front Convoy 3-5",
				},
				[6] = {
					name = "EAU East Front Convoy 3-6",
				},
				[7] = {
					name = "EAU East Front Convoy 3-7",
				},
				[8] = {
					name = "EAU East Front Convoy 3-8",
				},	
			},
		},
		["TF-71"] = {
			task = "Anti-ship Strike",
			priority = 10,
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 12,
			},
			class = "ship",
			name = "TF-71",
		},
		["LHA Group"] = {
			task = "Anti-ship Strike",
			priority = 10,
			attributes = {"ship"},
			firepower = {
				min = 4,
				max = 12,
			},
			class = "ship",
			name = "LHA Group",
		},		
		["EWR-1"] = {
			task = "Strike",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR-1",
		},
		["EWR-2"] = {
			task = "Strike",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR-2",
		},
		["EWR-3"] = {
			task = "Strike",
			priority = 20,
			attributes = {"soft"},
			firepower = {
				min = 2,
				max = 4,
			},
			class = "vehicle",
			name = "EWR-3",
		},
		["Dubai Intl OCA Strike"] = {
			task = "Strike",
			priority = 2,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 6,
			},
			class = "airbase",
			name = "Dubai Intl",
		},
		["Al Dhafra AB OCA Strike"] = {
			task = "Strike",
			priority = 2,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 6,
			},
			class = "airbase",
			name = "Al Dhafra AFB",
		},
		["Sharjah Intl OCA Strike"] = {
			task = "Strike",
			priority = 2,
			attributes = {"Parked Aircraft"},
			firepower = {
				min = 2,
				max = 6,
			},
			class = "airbase",
			name = "Sharjah Intl",
		},
		["Airlift Khasab"] = {
			task = "Transport",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Bandar Abbas Intl",
			destination = "Khasab",
		},
		["Airlift Khasab-2"] = {
			task = "Transport",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Shiraz Intl",
			destination = "Khasab",
		},
		["Airlift Al Ima basic FARP"] = {
			task = "Transport",
			priority = 100,
			attributes = {},
			firepower = {
				min = 1,
				max = 1,
			},
			base = "Qeshm Island",
			destination = "Al Ima basic FARP",
		},
	},
}